define(['app', 'angular'], function (app, angular) {

	app.directive('numbersOnly', function ($timeout) {
		return {
			restrict: 'A',
			require: 'ngModel',
			scope: {
				'ngModel': '=',
				'numbersOnly': '='
			},
			link:function(scope, elem, attrs, ngModelCtrl) {
				if(scope.numbersOnly) {
					ngModelCtrl.$parsers.push(function(newVal) {
						if (newVal == undefined) 
							return '';
		                
		                var transformedInput = newVal.replace(/[^0-9]/g, '');
		                if (transformedInput !== newVal) {
		                    ngModelCtrl.$setViewValue(transformedInput);
		                    ngModelCtrl.$commitViewValue();
		                    ngModelCtrl.$render();
		                    //ngModelCtrl.$validate();
		                    if(transformedInput == "" && attrs.ngRequired) {
		                    	ngModelCtrl.setValidity("required", true); 
		                    } 
		                }
		                return transformedInput;
					});
				}
			}
		};
	});
});